/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.integration.waila;

import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.entities.ImageEntity;
import java.util.Date;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.EntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.config.WailaConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class HUDHandlerImageFrame
implements IEntityComponentProvider {
    private static final ResourceLocation OBJECT_NAME_TAG = new ResourceLocation("waila", "object_name");
    public static final HUDHandlerImageFrame INSTANCE = new HUDHandlerImageFrame();

    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof ImageEntity) {
            ImageEntity image = (ImageEntity)entity;
            if (entityAccessor.getTooltipPosition().equals((Object)TooltipPosition.BODY)) {
                ImageData imageData = ImageData.fromStack(image.getItem());
                if (imageData == null) {
                    iTooltip.add((Component)new TranslatableComponent("tooltip.image_frame_empty"));
                    return;
                }
                if (!imageData.getOwner().isEmpty()) {
                    iTooltip.add((Component)new TranslatableComponent("tooltip.image_owner", new Object[]{ChatFormatting.DARK_GRAY + imageData.getOwner()}).m_130940_(ChatFormatting.GRAY));
                }
                if (imageData.getTime() > 0L) {
                    iTooltip.add((Component)new TranslatableComponent("tooltip.image_time", new Object[]{ChatFormatting.DARK_GRAY + Main.CLIENT_CONFIG.imageDateFormat.format(new Date(imageData.getTime()))}).m_130940_(ChatFormatting.GRAY));
                }
            } else if (entityAccessor.getTooltipPosition().equals((Object)TooltipPosition.HEAD)) {
                iTooltip.remove(OBJECT_NAME_TAG);
                iTooltip.add((Component)new TextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getEntityName(), image.m_5446_().getString())).m_130940_(ChatFormatting.WHITE));
            }
        }
    }
}

